//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of pulse width measurement mode of TCA0    
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
#define TEST_Signal_Width_L 0x34
#define TEST_Signal_Width_H 0x01
#define TEST_Signal_Period_L 0x34
#define TEST_Signal_Period_H 0x02
void main()
{
    WDCDR.byte = 0x4e;	//clear WDT   
	P8FC.bit.b1 = 1;	
	P8CR.bit.b1 = 1;	//set PPG3 for test signal
	P7CR.bit.b2 = 0;	//TCA0 input
	__asm("DI");
	POFFCR0.byte = 0x11;
	EIRH.bit.b6 = 1;
	__asm("EI");
	//=================
	// set PPG input signal
	// for testing Pulse width Measurement Mode
	// 
	// ================
	T023CR.bit.b2 = 1;
	T03MOD.byte = 0xCB;	//TFF =1,double buffer,sck = fcgck/2^10,16-bit PPG mode
	T02PWM.byte = TEST_Signal_Width_L;
	T03PWM.byte = TEST_Signal_Width_H;
	T02REG.byte = TEST_Signal_Period_L;
	T03REG.byte = TEST_Signal_Period_H;
	
	
	//=================
	// set Pulse width Measurement Mode
	// 
	// 
	// ================
	TA0CR.byte = 0xc0;	//enable Overflow interrupt,TFF=1,no noise canceller
						
	TA0MOD.byte = 0x86;	//double buffer,double edge capture,sck=fcgck/2^10,
						//Pulse width measurement mode
	//=================
	// start Pulse width Measurement Mode
	// ================
	TA0CR.bit.b0= 1;
	//=================
	// start PPG 
	// ================
	T001CR.bit.b1 = 1;
	
	
	while(1)
	{
		WDCDR.byte = 0x4e;	//clear WDT   
	}          
    
}